<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalGuestAmountType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAdditionalGuestAmountType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTotalType
     */
    public $Amount;
    /**
     * The AddlGuestAmtDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgParagraphType[]
     */
    public $AddlGuestAmtDescription;
    /**
     * The MaxAdditionalGuests
     * @var int
     */
    public $MaxAdditionalGuests;
    /**
     * The AgeQualifyingCode
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The MinAge
     * @var int
     */
    public $MinAge;
    /**
     * The MaxAge
     * @var int
     */
    public $MaxAge;
    /**
     * The AgeTimeUnit
     * @var string
     */
    public $AgeTimeUnit;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for AdditionalGuestAmountType
     * @uses DgAdditionalGuestAmountType::setAmount()
     * @uses DgAdditionalGuestAmountType::setAddlGuestAmtDescription()
     * @uses DgAdditionalGuestAmountType::setMaxAdditionalGuests()
     * @uses DgAdditionalGuestAmountType::setAgeQualifyingCode()
     * @uses DgAdditionalGuestAmountType::setMinAge()
     * @uses DgAdditionalGuestAmountType::setMaxAge()
     * @uses DgAdditionalGuestAmountType::setAgeTimeUnit()
     * @uses DgAdditionalGuestAmountType::setType()
     * @uses DgAdditionalGuestAmountType::setPercent()
     * @uses DgAdditionalGuestAmountType::setRPH()
     * @param \dgsoft\StructType\DgTotalType $amount
     * @param \dgsoft\StructType\DgParagraphType[] $addlGuestAmtDescription
     * @param int $maxAdditionalGuests
     * @param string $ageQualifyingCode
     * @param int $minAge
     * @param int $maxAge
     * @param string $ageTimeUnit
     * @param string $type
     * @param float $percent
     * @param string $rPH
     */
    public function __construct(\dgsoft\StructType\DgTotalType $amount = null, array $addlGuestAmtDescription = array(), $maxAdditionalGuests = null, $ageQualifyingCode = null, $minAge = null, $maxAge = null, $ageTimeUnit = null, $type = null, $percent = null, $rPH = null)
    {
        $this
            ->setAmount($amount)
            ->setAddlGuestAmtDescription($addlGuestAmtDescription)
            ->setMaxAdditionalGuests($maxAdditionalGuests)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setMinAge($minAge)
            ->setMaxAge($maxAge)
            ->setAgeTimeUnit($ageTimeUnit)
            ->setType($type)
            ->setPercent($percent)
            ->setRPH($rPH);
    }
    /**
     * Get Amount value
     * @return \dgsoft\StructType\DgTotalType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \dgsoft\StructType\DgTotalType $amount
     * @return \dgsoft\StructType\DgAdditionalGuestAmountType
     */
    public function setAmount(\dgsoft\StructType\DgTotalType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AddlGuestAmtDescription value
     * @return \dgsoft\StructType\DgParagraphType[]|null
     */
    public function getAddlGuestAmtDescription()
    {
        return $this->AddlGuestAmtDescription;
    }
    /**
     * Set AddlGuestAmtDescription value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgParagraphType[] $addlGuestAmtDescription
     * @return \dgsoft\StructType\DgAdditionalGuestAmountType
     */
    public function setAddlGuestAmtDescription(array $addlGuestAmtDescription = array())
    {
        foreach ($addlGuestAmtDescription as $additionalGuestAmountTypeAddlGuestAmtDescriptionItem) {
            // validation for constraint: itemType
            if (!$additionalGuestAmountTypeAddlGuestAmtDescriptionItem instanceof \dgsoft\StructType\DgParagraphType) {
                throw new \InvalidArgumentException(sprintf('The AddlGuestAmtDescription property can only contain items of \dgsoft\StructType\DgParagraphType, "%s" given', is_object($additionalGuestAmountTypeAddlGuestAmtDescriptionItem) ? get_class($additionalGuestAmountTypeAddlGuestAmtDescriptionItem) : gettype($additionalGuestAmountTypeAddlGuestAmtDescriptionItem)), __LINE__);
            }
        }
        $this->AddlGuestAmtDescription = $addlGuestAmtDescription;
        return $this;
    }
    /**
     * Add item to AddlGuestAmtDescription value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgParagraphType $item
     * @return \dgsoft\StructType\DgAdditionalGuestAmountType
     */
    public function addToAddlGuestAmtDescription(\dgsoft\StructType\DgParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgParagraphType) {
            throw new \InvalidArgumentException(sprintf('The AddlGuestAmtDescription property can only contain items of \dgsoft\StructType\DgParagraphType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AddlGuestAmtDescription[] = $item;
        return $this;
    }
    /**
     * Get MaxAdditionalGuests value
     * @return int|null
     */
    public function getMaxAdditionalGuests()
    {
        return $this->MaxAdditionalGuests;
    }
    /**
     * Set MaxAdditionalGuests value
     * @param int $maxAdditionalGuests
     * @return \dgsoft\StructType\DgAdditionalGuestAmountType
     */
    public function setMaxAdditionalGuests($maxAdditionalGuests = null)
    {
        // validation for constraint: int
        if (!is_null($maxAdditionalGuests) && !is_numeric($maxAdditionalGuests)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxAdditionalGuests)), __LINE__);
        }
        $this->MaxAdditionalGuests = $maxAdditionalGuests;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \dgsoft\StructType\DgAdditionalGuestAmountType
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ageQualifyingCode)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get MinAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param int $minAge
     * @return \dgsoft\StructType\DgAdditionalGuestAmountType
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !is_numeric($minAge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minAge)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param int $maxAge
     * @return \dgsoft\StructType\DgAdditionalGuestAmountType
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !is_numeric($maxAge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxAge)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Get AgeTimeUnit value
     * @return string|null
     */
    public function getAgeTimeUnit()
    {
        return $this->AgeTimeUnit;
    }
    /**
     * Set AgeTimeUnit value
     * @uses \dgsoft\EnumType\DgTimeUnitType::valueIsValid()
     * @uses \dgsoft\EnumType\DgTimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageTimeUnit
     * @return \dgsoft\StructType\DgAdditionalGuestAmountType
     */
    public function setAgeTimeUnit($ageTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTimeUnitType::valueIsValid($ageTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ageTimeUnit, implode(', ', \dgsoft\EnumType\DgTimeUnitType::getValidValues())), __LINE__);
        }
        $this->AgeTimeUnit = $ageTimeUnit;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \dgsoft\StructType\DgAdditionalGuestAmountType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \dgsoft\StructType\DgAdditionalGuestAmountType
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgAdditionalGuestAmountType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAdditionalGuestAmountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
