<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalCharge StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAdditionalCharge extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTotalType
     */
    public $Amount;
    /**
     * The RoomAmenityCode
     * @var string
     */
    public $RoomAmenityCode;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for AdditionalCharge
     * @uses DgAdditionalCharge::setAmount()
     * @uses DgAdditionalCharge::setRoomAmenityCode()
     * @uses DgAdditionalCharge::setQuantity()
     * @param \dgsoft\StructType\DgTotalType $amount
     * @param string $roomAmenityCode
     * @param int $quantity
     */
    public function __construct(\dgsoft\StructType\DgTotalType $amount = null, $roomAmenityCode = null, $quantity = null)
    {
        $this
            ->setAmount($amount)
            ->setRoomAmenityCode($roomAmenityCode)
            ->setQuantity($quantity);
    }
    /**
     * Get Amount value
     * @return \dgsoft\StructType\DgTotalType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \dgsoft\StructType\DgTotalType $amount
     * @return \dgsoft\StructType\DgAdditionalCharge
     */
    public function setAmount(\dgsoft\StructType\DgTotalType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get RoomAmenityCode value
     * @return string|null
     */
    public function getRoomAmenityCode()
    {
        return $this->RoomAmenityCode;
    }
    /**
     * Set RoomAmenityCode value
     * @param string $roomAmenityCode
     * @return \dgsoft\StructType\DgAdditionalCharge
     */
    public function setRoomAmenityCode($roomAmenityCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomAmenityCode) && !is_string($roomAmenityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomAmenityCode)), __LINE__);
        }
        $this->RoomAmenityCode = $roomAmenityCode;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \dgsoft\StructType\DgAdditionalCharge
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAdditionalCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
