<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Access StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAccess extends AbstractStructBase
{
    /**
     * The AccessPerson
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $AccessPerson;
    /**
     * The AccessComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFreeTextType
     */
    public $AccessComment;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ActionDateTime
     * @var string
     */
    public $ActionDateTime;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * Constructor method for Access
     * @uses DgAccess::setAccessPerson()
     * @uses DgAccess::setAccessComment()
     * @uses DgAccess::setActionType()
     * @uses DgAccess::setActionDateTime()
     * @uses DgAccess::setID()
     * @param \dgsoft\StructType\DgPersonNameType $accessPerson
     * @param \dgsoft\StructType\DgFreeTextType $accessComment
     * @param string $actionType
     * @param string $actionDateTime
     * @param string $iD
     */
    public function __construct(\dgsoft\StructType\DgPersonNameType $accessPerson = null, \dgsoft\StructType\DgFreeTextType $accessComment = null, $actionType = null, $actionDateTime = null, $iD = null)
    {
        $this
            ->setAccessPerson($accessPerson)
            ->setAccessComment($accessComment)
            ->setActionType($actionType)
            ->setActionDateTime($actionDateTime)
            ->setID($iD);
    }
    /**
     * Get AccessPerson value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getAccessPerson()
    {
        return $this->AccessPerson;
    }
    /**
     * Set AccessPerson value
     * @param \dgsoft\StructType\DgPersonNameType $accessPerson
     * @return \dgsoft\StructType\DgAccess
     */
    public function setAccessPerson(\dgsoft\StructType\DgPersonNameType $accessPerson = null)
    {
        $this->AccessPerson = $accessPerson;
        return $this;
    }
    /**
     * Get AccessComment value
     * @return \dgsoft\StructType\DgFreeTextType|null
     */
    public function getAccessComment()
    {
        return $this->AccessComment;
    }
    /**
     * Set AccessComment value
     * @param \dgsoft\StructType\DgFreeTextType $accessComment
     * @return \dgsoft\StructType\DgAccess
     */
    public function setAccessComment(\dgsoft\StructType\DgFreeTextType $accessComment = null)
    {
        $this->AccessComment = $accessComment;
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @param string $actionType
     * @return \dgsoft\StructType\DgAccess
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: string
        if (!is_null($actionType) && !is_string($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actionType)), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ActionDateTime value
     * @return string|null
     */
    public function getActionDateTime()
    {
        return $this->ActionDateTime;
    }
    /**
     * Set ActionDateTime value
     * @param string $actionDateTime
     * @return \dgsoft\StructType\DgAccess
     */
    public function setActionDateTime($actionDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($actionDateTime) && !is_string($actionDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actionDateTime)), __LINE__);
        }
        $this->ActionDateTime = $actionDateTime;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \dgsoft\StructType\DgAccess
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAccess
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
