<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APISRulesRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAPISRulesRQ extends AbstractStructBase
{
    /**
     * The RecommendationID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $RecommendationID;
    /**
     * The CombinationID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $CombinationID;
    /**
     * Constructor method for APISRulesRQ
     * @uses DgAPISRulesRQ::setRecommendationID()
     * @uses DgAPISRulesRQ::setCombinationID()
     * @param int $recommendationID
     * @param int $combinationID
     */
    public function __construct($recommendationID = null, $combinationID = null)
    {
        $this
            ->setRecommendationID($recommendationID)
            ->setCombinationID($combinationID);
    }
    /**
     * Get RecommendationID value
     * @return int
     */
    public function getRecommendationID()
    {
        return $this->RecommendationID;
    }
    /**
     * Set RecommendationID value
     * @param int $recommendationID
     * @return \dgsoft\StructType\DgAPISRulesRQ
     */
    public function setRecommendationID($recommendationID = null)
    {
        // validation for constraint: int
        if (!is_null($recommendationID) && !is_numeric($recommendationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recommendationID)), __LINE__);
        }
        $this->RecommendationID = $recommendationID;
        return $this;
    }
    /**
     * Get CombinationID value
     * @return int
     */
    public function getCombinationID()
    {
        return $this->CombinationID;
    }
    /**
     * Set CombinationID value
     * @param int $combinationID
     * @return \dgsoft\StructType\DgAPISRulesRQ
     */
    public function setCombinationID($combinationID = null)
    {
        // validation for constraint: int
        if (!is_null($combinationID) && !is_numeric($combinationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($combinationID)), __LINE__);
        }
        $this->CombinationID = $combinationID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAPISRulesRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
