<?php

namespace dgsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @package Dg
 * @subpackage Services
 */
class DgSearch extends AbstractSoapClientBase
{
    /**
     * Sets the AuthenticationSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \dgsoft\StructType\DgAuthenticationSoapHeader $authenticationSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticationSoapHeader(\dgsoft\StructType\DgAuthenticationSoapHeader $authenticationSoapHeader, $nameSpace = 'http://epowerv5.amadeus.com.tr/WS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticationSoapHeader', $authenticationSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the GenericSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \dgsoft\StructType\DgGenericSoapHeader $genericSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderGenericSoapHeader(\dgsoft\StructType\DgGenericSoapHeader $genericSoapHeader, $nameSpace = 'http://epowerv5.amadeus.com.tr/WS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'GenericSoapHeader', $genericSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SearchFlight
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgSearchFlight $parameters
     * @return \dgsoft\StructType\DgSearchFlightResponse|bool
     */
    public function SearchFlight(\dgsoft\StructType\DgSearchFlight $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchFlight($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchFlightCalendar
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgSearchFlightCalendar $parameters
     * @return \dgsoft\StructType\DgSearchFlightCalendarResponse|bool
     */
    public function SearchFlightCalendar(\dgsoft\StructType\DgSearchFlightCalendar $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchFlightCalendar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchFlightTimeTable
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgSearchFlightTimeTable $parameters
     * @return \dgsoft\StructType\DgSearchFlightTimeTableResponse|bool
     */
    public function SearchFlightTimeTable(\dgsoft\StructType\DgSearchFlightTimeTable $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchFlightTimeTable($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchHotel
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgSearchHotel $parameters
     * @return \dgsoft\StructType\DgSearchHotelResponse|bool
     */
    public function SearchHotel(\dgsoft\StructType\DgSearchHotel $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchHotel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchHotelRooms
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgSearchHotelRooms $parameters
     * @return \dgsoft\StructType\DgSearchHotelRoomsResponse|bool
     */
    public function SearchHotelRooms(\dgsoft\StructType\DgSearchHotelRooms $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchHotelRooms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchCar
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgSearchCar $parameters
     * @return \dgsoft\StructType\DgSearchCarResponse|bool
     */
    public function SearchCar(\dgsoft\StructType\DgSearchCar $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchCar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchCarVendor
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgSearchCarVendor $parameters
     * @return \dgsoft\StructType\DgSearchCarVendorResponse|bool
     */
    public function SearchCarVendor(\dgsoft\StructType\DgSearchCarVendor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchCarVendor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchInsurancePlans
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgSearchInsurancePlans $parameters
     * @return \dgsoft\StructType\DgSearchInsurancePlansResponse|bool
     */
    public function SearchInsurancePlans(\dgsoft\StructType\DgSearchInsurancePlans $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchInsurancePlans($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \dgsoft\StructType\DgSearchCarResponse|\dgsoft\StructType\DgSearchCarVendorResponse|\dgsoft\StructType\DgSearchFlightCalendarResponse|\dgsoft\StructType\DgSearchFlightResponse|\dgsoft\StructType\DgSearchFlightTimeTableResponse|\dgsoft\StructType\DgSearchHotelResponse|\dgsoft\StructType\DgSearchHotelRoomsResponse|\dgsoft\StructType\DgSearchInsurancePlansResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
