<?php

namespace dgsoft\EnumType;

/**
 * This class stands for
 * VehicleReservationRQAdditionalInfoTypeRentalPaymentPrefType EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgVehicleReservationRQAdditionalInfoTypeRentalPaymentPrefType
{
    /**
     * Constant for value 'guarantee'
     * @return string 'guarantee'
     */
    const VALUE_GUARANTEE = 'guarantee';
    /**
     * Constant for value 'payment'
     * @return string 'payment'
     */
    const VALUE_PAYMENT = 'payment';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GUARANTEE
     * @uses self::VALUE_PAYMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GUARANTEE,
            self::VALUE_PAYMENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
