<?php

namespace dgsoft\EnumType;

/**
 * This class stands for VehicleRentalRateTypePickupReturnRuleRuleType EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgVehicleRentalRateTypePickupReturnRuleRuleType
{
    /**
     * Constant for value 'EarliestPickup'
     * @return string 'EarliestPickup'
     */
    const VALUE_EARLIEST_PICKUP = 'EarliestPickup';
    /**
     * Constant for value 'LatestPickup'
     * @return string 'LatestPickup'
     */
    const VALUE_LATEST_PICKUP = 'LatestPickup';
    /**
     * Constant for value 'LatestReturn'
     * @return string 'LatestReturn'
     */
    const VALUE_LATEST_RETURN = 'LatestReturn';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EARLIEST_PICKUP
     * @uses self::VALUE_LATEST_PICKUP
     * @uses self::VALUE_LATEST_RETURN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EARLIEST_PICKUP,
            self::VALUE_LATEST_PICKUP,
            self::VALUE_LATEST_RETURN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
