<?php

namespace dgsoft\EnumType;

/**
 * This class stands for VehicleChargeTypeCalculationApplicability EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgVehicleChargeTypeCalculationApplicability
{
    /**
     * Constant for value 'FromPickupLocation'
     * @return string 'FromPickupLocation'
     */
    const VALUE_FROM_PICKUP_LOCATION = 'FromPickupLocation';
    /**
     * Constant for value 'FromDropoffLocation'
     * @return string 'FromDropoffLocation'
     */
    const VALUE_FROM_DROPOFF_LOCATION = 'FromDropoffLocation';
    /**
     * Constant for value 'BeforePickup'
     * @return string 'BeforePickup'
     */
    const VALUE_BEFORE_PICKUP = 'BeforePickup';
    /**
     * Constant for value 'AfterDropoff'
     * @return string 'AfterDropoff'
     */
    const VALUE_AFTER_DROPOFF = 'AfterDropoff';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FROM_PICKUP_LOCATION
     * @uses self::VALUE_FROM_DROPOFF_LOCATION
     * @uses self::VALUE_BEFORE_PICKUP
     * @uses self::VALUE_AFTER_DROPOFF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FROM_PICKUP_LOCATION,
            self::VALUE_FROM_DROPOFF_LOCATION,
            self::VALUE_BEFORE_PICKUP,
            self::VALUE_AFTER_DROPOFF,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
