<?php

namespace dgsoft\EnumType;

/**
 * This class stands for VehicleAvailCoreTypeVendorLocationCounterLocInfo EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgVehicleAvailCoreTypeVendorLocationCounterLocInfo
{
    /**
     * Constant for value 'WalkToCar'
     * @return string 'WalkToCar'
     */
    const VALUE_WALK_TO_CAR = 'WalkToCar';
    /**
     * Constant for value 'ShuttleToCar'
     * @return string 'ShuttleToCar'
     */
    const VALUE_SHUTTLE_TO_CAR = 'ShuttleToCar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WALK_TO_CAR
     * @uses self::VALUE_SHUTTLE_TO_CAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WALK_TO_CAR,
            self::VALUE_SHUTTLE_TO_CAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
