<?php

namespace dgsoft\EnumType;

/**
 * This class stands for ValidationErrorCategories EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgValidationErrorCategories
{
    /**
     * Constant for value 'System'
     * @return string 'System'
     */
    const VALUE_SYSTEM = 'System';
    /**
     * Constant for value 'AmadeusAPI'
     * @return string 'AmadeusAPI'
     */
    const VALUE_AMADEUS_API = 'AmadeusAPI';
    /**
     * Constant for value 'FatalError'
     * @return string 'FatalError'
     */
    const VALUE_FATAL_ERROR = 'FatalError';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SYSTEM
     * @uses self::VALUE_AMADEUS_API
     * @uses self::VALUE_FATAL_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SYSTEM,
            self::VALUE_AMADEUS_API,
            self::VALUE_FATAL_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
