<?php

namespace dgsoft\EnumType;

/**
 * This class stands for SearchTypeByProviderEnum EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgSearchTypeByProviderEnum
{
    /**
     * Constant for value 'OnlyAmadeus'
     * @return string 'OnlyAmadeus'
     */
    const VALUE_ONLY_AMADEUS = 'OnlyAmadeus';
    /**
     * Constant for value 'AmadeusAndExtProviders'
     * @return string 'AmadeusAndExtProviders'
     */
    const VALUE_AMADEUS_AND_EXT_PROVIDERS = 'AmadeusAndExtProviders';
    /**
     * Constant for value 'OnlyExtProviders'
     * @return string 'OnlyExtProviders'
     */
    const VALUE_ONLY_EXT_PROVIDERS = 'OnlyExtProviders';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONLY_AMADEUS
     * @uses self::VALUE_AMADEUS_AND_EXT_PROVIDERS
     * @uses self::VALUE_ONLY_EXT_PROVIDERS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONLY_AMADEUS,
            self::VALUE_AMADEUS_AND_EXT_PROVIDERS,
            self::VALUE_ONLY_EXT_PROVIDERS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
