<?php

namespace dgsoft\EnumType;

/**
 * This class stands for PaymentTypes EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgPaymentTypes
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'CallMe'
     * @return string 'CallMe'
     */
    const VALUE_CALL_ME = 'CallMe';
    /**
     * Constant for value 'CreditCard'
     * @return string 'CreditCard'
     */
    const VALUE_CREDIT_CARD = 'CreditCard';
    /**
     * Constant for value 'Invoice'
     * @return string 'Invoice'
     */
    const VALUE_INVOICE = 'Invoice';
    /**
     * Constant for value 'PayAtAgency'
     * @return string 'PayAtAgency'
     */
    const VALUE_PAY_AT_AGENCY = 'PayAtAgency';
    /**
     * Constant for value 'C'
     * @return string 'C'
     */
    const VALUE_C = 'C';
    /**
     * Constant for value 'CC'
     * @return string 'CC'
     */
    const VALUE_CC = 'CC';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_CALL_ME
     * @uses self::VALUE_CREDIT_CARD
     * @uses self::VALUE_INVOICE
     * @uses self::VALUE_PAY_AT_AGENCY
     * @uses self::VALUE_C
     * @uses self::VALUE_CC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_CALL_ME,
            self::VALUE_CREDIT_CARD,
            self::VALUE_INVOICE,
            self::VALUE_PAY_AT_AGENCY,
            self::VALUE_C,
            self::VALUE_CC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
