<?php

namespace dgsoft\EnumType;

/**
 * This class stands for PaymentFPTypes EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgPaymentFPTypes
{
    /**
     * Constant for value 'FPCA'
     * @return string 'FPCA'
     */
    const VALUE_FPCA = 'FPCA';
    /**
     * Constant for value 'FPCC'
     * @return string 'FPCC'
     */
    const VALUE_FPCC = 'FPCC';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FPCA
     * @uses self::VALUE_FPCC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FPCA,
            self::VALUE_FPCC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
