<?php

namespace dgsoft\EnumType;

/**
 * This class stands for OTA_InsuranceBookRSTransactionStatusCode EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgOTA_InsuranceBookRSTransactionStatusCode
{
    /**
     * Constant for value 'Start'
     * @return string 'Start'
     */
    const VALUE_START = 'Start';
    /**
     * Constant for value 'End'
     * @return string 'End'
     */
    const VALUE_END = 'End';
    /**
     * Constant for value 'Rollback'
     * @return string 'Rollback'
     */
    const VALUE_ROLLBACK = 'Rollback';
    /**
     * Constant for value 'InSeries'
     * @return string 'InSeries'
     */
    const VALUE_IN_SERIES = 'InSeries';
    /**
     * Constant for value 'Continuation'
     * @return string 'Continuation'
     */
    const VALUE_CONTINUATION = 'Continuation';
    /**
     * Constant for value 'Subsequent'
     * @return string 'Subsequent'
     */
    const VALUE_SUBSEQUENT = 'Subsequent';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_START
     * @uses self::VALUE_END
     * @uses self::VALUE_ROLLBACK
     * @uses self::VALUE_IN_SERIES
     * @uses self::VALUE_CONTINUATION
     * @uses self::VALUE_SUBSEQUENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_START,
            self::VALUE_END,
            self::VALUE_ROLLBACK,
            self::VALUE_IN_SERIES,
            self::VALUE_CONTINUATION,
            self::VALUE_SUBSEQUENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
