<?php

namespace dgsoft\EnumType;

/**
 * This class stands for OTA_AirScheduleRQFlightTypePrefNonScheduledFltInfo
 * EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgOTA_AirScheduleRQFlightTypePrefNonScheduledFltInfo
{
    /**
     * Constant for value 'ChartersOnly'
     * @return string 'ChartersOnly'
     */
    const VALUE_CHARTERS_ONLY = 'ChartersOnly';
    /**
     * Constant for value 'ExcludeCharters'
     * @return string 'ExcludeCharters'
     */
    const VALUE_EXCLUDE_CHARTERS = 'ExcludeCharters';
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CHARTERS_ONLY
     * @uses self::VALUE_EXCLUDE_CHARTERS
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CHARTERS_ONLY,
            self::VALUE_EXCLUDE_CHARTERS,
            self::VALUE_ALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
