<?php

namespace dgsoft\EnumType;

/**
 * This class stands for InsCoverageDetailTypeType EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgInsCoverageDetailTypeType
{
    /**
     * Constant for value 'SingleTrip'
     * @return string 'SingleTrip'
     */
    const VALUE_SINGLE_TRIP = 'SingleTrip';
    /**
     * Constant for value 'MultiTrip'
     * @return string 'MultiTrip'
     */
    const VALUE_MULTI_TRIP = 'MultiTrip';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SINGLE_TRIP
     * @uses self::VALUE_MULTI_TRIP
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SINGLE_TRIP,
            self::VALUE_MULTI_TRIP,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
