<?php

namespace dgsoft\EnumType;

/**
 * This class stands for HotelProviderTypeEnum EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgHotelProviderTypeEnum
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'GoGlobal'
     * @return string 'GoGlobal'
     */
    const VALUE_GO_GLOBAL = 'GoGlobal';
    /**
     * Constant for value 'HotelsPro'
     * @return string 'HotelsPro'
     */
    const VALUE_HOTELS_PRO = 'HotelsPro';
    /**
     * Constant for value 'AmadeusProvider'
     * @return string 'AmadeusProvider'
     */
    const VALUE_AMADEUS_PROVIDER = 'AmadeusProvider';
    /**
     * Constant for value 'ContentInn'
     * @return string 'ContentInn'
     */
    const VALUE_CONTENT_INN = 'ContentInn';
    /**
     * Constant for value 'SunHotels'
     * @return string 'SunHotels'
     */
    const VALUE_SUN_HOTELS = 'SunHotels';
    /**
     * Constant for value 'ContentStore'
     * @return string 'ContentStore'
     */
    const VALUE_CONTENT_STORE = 'ContentStore';
    /**
     * Constant for value 'Albatravel'
     * @return string 'Albatravel'
     */
    const VALUE_ALBATRAVEL = 'Albatravel';
    /**
     * Constant for value 'Bedsonline'
     * @return string 'Bedsonline'
     */
    const VALUE_BEDSONLINE = 'Bedsonline';
    /**
     * Constant for value 'Transhotel'
     * @return string 'Transhotel'
     */
    const VALUE_TRANSHOTEL = 'Transhotel';
    /**
     * Constant for value 'GTA'
     * @return string 'GTA'
     */
    const VALUE_GTA = 'GTA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_GO_GLOBAL
     * @uses self::VALUE_HOTELS_PRO
     * @uses self::VALUE_AMADEUS_PROVIDER
     * @uses self::VALUE_CONTENT_INN
     * @uses self::VALUE_SUN_HOTELS
     * @uses self::VALUE_CONTENT_STORE
     * @uses self::VALUE_ALBATRAVEL
     * @uses self::VALUE_BEDSONLINE
     * @uses self::VALUE_TRANSHOTEL
     * @uses self::VALUE_GTA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_GO_GLOBAL,
            self::VALUE_HOTELS_PRO,
            self::VALUE_AMADEUS_PROVIDER,
            self::VALUE_CONTENT_INN,
            self::VALUE_SUN_HOTELS,
            self::VALUE_CONTENT_STORE,
            self::VALUE_ALBATRAVEL,
            self::VALUE_BEDSONLINE,
            self::VALUE_TRANSHOTEL,
            self::VALUE_GTA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
