<?php

namespace dgsoft\EnumType;

/**
 * This class stands for ExpandedParameterEnum EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgExpandedParameterEnum
{
    /**
     * Constant for value 'NAP'
     * @return string 'NAP'
     */
    const VALUE_NAP = 'NAP';
    /**
     * Constant for value 'NPE'
     * @return string 'NPE'
     */
    const VALUE_NPE = 'NPE';
    /**
     * Constant for value 'NR'
     * @return string 'NR'
     */
    const VALUE_NR = 'NR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NAP
     * @uses self::VALUE_NPE
     * @uses self::VALUE_NR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NAP,
            self::VALUE_NPE,
            self::VALUE_NR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
