<?php

namespace dgsoft\EnumType;

/**
 * This class stands for DuplicatedRecommedationsBehaviorEnum EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgDuplicatedRecommedationsBehaviorEnum
{
    /**
     * Constant for value 'RDG'
     * @return string 'RDG'
     */
    const VALUE_RDG = 'RDG';
    /**
     * Constant for value 'RDM'
     * @return string 'RDM'
     */
    const VALUE_RDM = 'RDM';
    /**
     * Constant for value 'NONE'
     * @return string 'NONE'
     */
    const VALUE_NONE = 'NONE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RDG
     * @uses self::VALUE_RDM
     * @uses self::VALUE_NONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RDG,
            self::VALUE_RDM,
            self::VALUE_NONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
