<?php

namespace dgsoft\EnumType;

/**
 * This class stands for DisplayRuleEnum EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgDisplayRuleEnum
{
    /**
     * Constant for value 'DISPLAYALLOPTIONS'
     * @return string 'DISPLAYALLOPTIONS'
     */
    const VALUE_DISPLAYALLOPTIONS = 'DISPLAYALLOPTIONS';
    /**
     * Constant for value 'DISPLAYONLYINPOLICYOPTIONS'
     * @return string 'DISPLAYONLYINPOLICYOPTIONS'
     */
    const VALUE_DISPLAYONLYINPOLICYOPTIONS = 'DISPLAYONLYINPOLICYOPTIONS';
    /**
     * Constant for value 'DISPLAYONLYOUTPOLICYOPTIONSIFNOINPOLICYOPTION'
     * @return string 'DISPLAYONLYOUTPOLICYOPTIONSIFNOINPOLICYOPTION'
     */
    const VALUE_DISPLAYONLYOUTPOLICYOPTIONSIFNOINPOLICYOPTION = 'DISPLAYONLYOUTPOLICYOPTIONSIFNOINPOLICYOPTION';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DISPLAYALLOPTIONS
     * @uses self::VALUE_DISPLAYONLYINPOLICYOPTIONS
     * @uses self::VALUE_DISPLAYONLYOUTPOLICYOPTIONSIFNOINPOLICYOPTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISPLAYALLOPTIONS,
            self::VALUE_DISPLAYONLYINPOLICYOPTIONS,
            self::VALUE_DISPLAYONLYOUTPOLICYOPTIONSIFNOINPOLICYOPTION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
