<?php

namespace dgsoft\EnumType;

/**
 * This class stands for CabinType EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgCabinType
{
    /**
     * Constant for value 'First'
     * @return string 'First'
     */
    const VALUE_FIRST = 'First';
    /**
     * Constant for value 'Business'
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'Economy'
     * @return string 'Economy'
     */
    const VALUE_ECONOMY = 'Economy';
    /**
     * Constant for value 'Premium'
     * @return string 'Premium'
     */
    const VALUE_PREMIUM = 'Premium';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIRST
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_ECONOMY
     * @uses self::VALUE_PREMIUM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIRST,
            self::VALUE_BUSINESS,
            self::VALUE_ECONOMY,
            self::VALUE_PREMIUM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
