<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVehicleChargeTypeTaxAmount ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfVehicleChargeTypeTaxAmount extends AbstractStructArrayBase
{
    /**
     * The CarTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleChargeTypeTaxAmount[]
     */
    public $CarTax;
    /**
     * Constructor method for ArrayOfVehicleChargeTypeTaxAmount
     * @uses DgArrayOfVehicleChargeTypeTaxAmount::setCarTax()
     * @param \dgsoft\StructType\DgVehicleChargeTypeTaxAmount[] $carTax
     */
    public function __construct(array $carTax = array())
    {
        $this
            ->setCarTax($carTax);
    }
    /**
     * Get CarTax value
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount[]|null
     */
    public function getCarTax()
    {
        return $this->CarTax;
    }
    /**
     * Set CarTax value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleChargeTypeTaxAmount[] $carTax
     * @return \dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount
     */
    public function setCarTax(array $carTax = array())
    {
        foreach ($carTax as $arrayOfVehicleChargeTypeTaxAmountCarTaxItem) {
            // validation for constraint: itemType
            if (!$arrayOfVehicleChargeTypeTaxAmountCarTaxItem instanceof \dgsoft\StructType\DgVehicleChargeTypeTaxAmount) {
                throw new \InvalidArgumentException(sprintf('The CarTax property can only contain items of \dgsoft\StructType\DgVehicleChargeTypeTaxAmount, "%s" given', is_object($arrayOfVehicleChargeTypeTaxAmountCarTaxItem) ? get_class($arrayOfVehicleChargeTypeTaxAmountCarTaxItem) : gettype($arrayOfVehicleChargeTypeTaxAmountCarTaxItem)), __LINE__);
            }
        }
        $this->CarTax = $carTax;
        return $this;
    }
    /**
     * Add item to CarTax value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleChargeTypeTaxAmount $item
     * @return \dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount
     */
    public function addToCarTax(\dgsoft\StructType\DgVehicleChargeTypeTaxAmount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleChargeTypeTaxAmount) {
            throw new \InvalidArgumentException(sprintf('The CarTax property can only contain items of \dgsoft\StructType\DgVehicleChargeTypeTaxAmount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CarTax[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgVehicleChargeTypeTaxAmount|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CarTax
     */
    public function getAttributeName()
    {
        return 'CarTax';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfVehicleChargeTypeTaxAmount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
