<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTaxInfo ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfTaxInfo extends AbstractStructArrayBase
{
    /**
     * The TaxInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgTaxInfo[]
     */
    public $TaxInfo;
    /**
     * Constructor method for ArrayOfTaxInfo
     * @uses DgArrayOfTaxInfo::setTaxInfo()
     * @param \dgsoft\StructType\DgTaxInfo[] $taxInfo
     */
    public function __construct(array $taxInfo = array())
    {
        $this
            ->setTaxInfo($taxInfo);
    }
    /**
     * Get TaxInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgTaxInfo[]|null
     */
    public function getTaxInfo()
    {
        return isset($this->TaxInfo) ? $this->TaxInfo : null;
    }
    /**
     * Set TaxInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTaxInfo[] $taxInfo
     * @return \dgsoft\ArrayType\DgArrayOfTaxInfo
     */
    public function setTaxInfo(array $taxInfo = array())
    {
        foreach ($taxInfo as $arrayOfTaxInfoTaxInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfTaxInfoTaxInfoItem instanceof \dgsoft\StructType\DgTaxInfo) {
                throw new \InvalidArgumentException(sprintf('The TaxInfo property can only contain items of \dgsoft\StructType\DgTaxInfo, "%s" given', is_object($arrayOfTaxInfoTaxInfoItem) ? get_class($arrayOfTaxInfoTaxInfoItem) : gettype($arrayOfTaxInfoTaxInfoItem)), __LINE__);
            }
        }
        if (is_null($taxInfo) || (is_array($taxInfo) && empty($taxInfo))) {
            unset($this->TaxInfo);
        } else {
            $this->TaxInfo = $taxInfo;
        }
        return $this;
    }
    /**
     * Add item to TaxInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTaxInfo $item
     * @return \dgsoft\ArrayType\DgArrayOfTaxInfo
     */
    public function addToTaxInfo(\dgsoft\StructType\DgTaxInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTaxInfo) {
            throw new \InvalidArgumentException(sprintf('The TaxInfo property can only contain items of \dgsoft\StructType\DgTaxInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TaxInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgTaxInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgTaxInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgTaxInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgTaxInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgTaxInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TaxInfo
     */
    public function getAttributeName()
    {
        return 'TaxInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfTaxInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
