<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString3 ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfString3 extends AbstractStructArrayBase
{
    /**
     * The FlightSegmentRPH
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FlightSegmentRPH;
    /**
     * Constructor method for ArrayOfString3
     * @uses DgArrayOfString3::setFlightSegmentRPH()
     * @param string[] $flightSegmentRPH
     */
    public function __construct(array $flightSegmentRPH = array())
    {
        $this
            ->setFlightSegmentRPH($flightSegmentRPH);
    }
    /**
     * Get FlightSegmentRPH value
     * @return string[]|null
     */
    public function getFlightSegmentRPH()
    {
        return $this->FlightSegmentRPH;
    }
    /**
     * Set FlightSegmentRPH value
     * @throws \InvalidArgumentException
     * @param string[] $flightSegmentRPH
     * @return \dgsoft\ArrayType\DgArrayOfString3
     */
    public function setFlightSegmentRPH(array $flightSegmentRPH = array())
    {
        foreach ($flightSegmentRPH as $arrayOfString3FlightSegmentRPHItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString3FlightSegmentRPHItem)) {
                throw new \InvalidArgumentException(sprintf('The FlightSegmentRPH property can only contain items of string, "%s" given', is_object($arrayOfString3FlightSegmentRPHItem) ? get_class($arrayOfString3FlightSegmentRPHItem) : gettype($arrayOfString3FlightSegmentRPHItem)), __LINE__);
            }
        }
        $this->FlightSegmentRPH = $flightSegmentRPH;
        return $this;
    }
    /**
     * Add item to FlightSegmentRPH value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\ArrayType\DgArrayOfString3
     */
    public function addToFlightSegmentRPH($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FlightSegmentRPH property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightSegmentRPH[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FlightSegmentRPH
     */
    public function getAttributeName()
    {
        return 'FlightSegmentRPH';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfString3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
