<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString1 ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfString1 extends AbstractStructArrayBase
{
    /**
     * The AdditionalPersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AdditionalPersonName;
    /**
     * Constructor method for ArrayOfString1
     * @uses DgArrayOfString1::setAdditionalPersonName()
     * @param string[] $additionalPersonName
     */
    public function __construct(array $additionalPersonName = array())
    {
        $this
            ->setAdditionalPersonName($additionalPersonName);
    }
    /**
     * Get AdditionalPersonName value
     * @return string[]|null
     */
    public function getAdditionalPersonName()
    {
        return $this->AdditionalPersonName;
    }
    /**
     * Set AdditionalPersonName value
     * @throws \InvalidArgumentException
     * @param string[] $additionalPersonName
     * @return \dgsoft\ArrayType\DgArrayOfString1
     */
    public function setAdditionalPersonName(array $additionalPersonName = array())
    {
        foreach ($additionalPersonName as $arrayOfString1AdditionalPersonNameItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString1AdditionalPersonNameItem)) {
                throw new \InvalidArgumentException(sprintf('The AdditionalPersonName property can only contain items of string, "%s" given', is_object($arrayOfString1AdditionalPersonNameItem) ? get_class($arrayOfString1AdditionalPersonNameItem) : gettype($arrayOfString1AdditionalPersonNameItem)), __LINE__);
            }
        }
        $this->AdditionalPersonName = $additionalPersonName;
        return $this;
    }
    /**
     * Add item to AdditionalPersonName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\ArrayType\DgArrayOfString1
     */
    public function addToAdditionalPersonName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AdditionalPersonName property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdditionalPersonName[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AdditionalPersonName
     */
    public function getAttributeName()
    {
        return 'AdditionalPersonName';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfString1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
