<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSpecialRequestChange ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfSpecialRequestChange extends AbstractStructArrayBase
{
    /**
     * The SpecialRequestChange
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgSpecialRequestChange[]
     */
    public $SpecialRequestChange;
    /**
     * Constructor method for ArrayOfSpecialRequestChange
     * @uses DgArrayOfSpecialRequestChange::setSpecialRequestChange()
     * @param \dgsoft\StructType\DgSpecialRequestChange[] $specialRequestChange
     */
    public function __construct(array $specialRequestChange = array())
    {
        $this
            ->setSpecialRequestChange($specialRequestChange);
    }
    /**
     * Get SpecialRequestChange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgSpecialRequestChange[]|null
     */
    public function getSpecialRequestChange()
    {
        return isset($this->SpecialRequestChange) ? $this->SpecialRequestChange : null;
    }
    /**
     * Set SpecialRequestChange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecialRequestChange[] $specialRequestChange
     * @return \dgsoft\ArrayType\DgArrayOfSpecialRequestChange
     */
    public function setSpecialRequestChange(array $specialRequestChange = array())
    {
        foreach ($specialRequestChange as $arrayOfSpecialRequestChangeSpecialRequestChangeItem) {
            // validation for constraint: itemType
            if (!$arrayOfSpecialRequestChangeSpecialRequestChangeItem instanceof \dgsoft\StructType\DgSpecialRequestChange) {
                throw new \InvalidArgumentException(sprintf('The SpecialRequestChange property can only contain items of \dgsoft\StructType\DgSpecialRequestChange, "%s" given', is_object($arrayOfSpecialRequestChangeSpecialRequestChangeItem) ? get_class($arrayOfSpecialRequestChangeSpecialRequestChangeItem) : gettype($arrayOfSpecialRequestChangeSpecialRequestChangeItem)), __LINE__);
            }
        }
        if (is_null($specialRequestChange) || (is_array($specialRequestChange) && empty($specialRequestChange))) {
            unset($this->SpecialRequestChange);
        } else {
            $this->SpecialRequestChange = $specialRequestChange;
        }
        return $this;
    }
    /**
     * Add item to SpecialRequestChange value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecialRequestChange $item
     * @return \dgsoft\ArrayType\DgArrayOfSpecialRequestChange
     */
    public function addToSpecialRequestChange(\dgsoft\StructType\DgSpecialRequestChange $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSpecialRequestChange) {
            throw new \InvalidArgumentException(sprintf('The SpecialRequestChange property can only contain items of \dgsoft\StructType\DgSpecialRequestChange, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialRequestChange[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgSpecialRequestChange|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgSpecialRequestChange|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgSpecialRequestChange|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgSpecialRequestChange|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgSpecialRequestChange|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SpecialRequestChange
     */
    public function getAttributeName()
    {
        return 'SpecialRequestChange';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfSpecialRequestChange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
