<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSpecialReqDetailsTypeSpecialServiceRequest
 * ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfSpecialReqDetailsTypeSpecialServiceRequest extends AbstractStructArrayBase
{
    /**
     * The SpecialServiceRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSpecialServiceRequest[]
     */
    public $SpecialServiceRequest;
    /**
     * Constructor method for ArrayOfSpecialReqDetailsTypeSpecialServiceRequest
     * @uses DgArrayOfSpecialReqDetailsTypeSpecialServiceRequest::setSpecialServiceRequest()
     * @param \dgsoft\StructType\DgSpecialServiceRequest[] $specialServiceRequest
     */
    public function __construct(array $specialServiceRequest = array())
    {
        $this
            ->setSpecialServiceRequest($specialServiceRequest);
    }
    /**
     * Get SpecialServiceRequest value
     * @return \dgsoft\StructType\DgSpecialServiceRequest[]|null
     */
    public function getSpecialServiceRequest()
    {
        return $this->SpecialServiceRequest;
    }
    /**
     * Set SpecialServiceRequest value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecialServiceRequest[] $specialServiceRequest
     * @return \dgsoft\ArrayType\DgArrayOfSpecialReqDetailsTypeSpecialServiceRequest
     */
    public function setSpecialServiceRequest(array $specialServiceRequest = array())
    {
        foreach ($specialServiceRequest as $arrayOfSpecialReqDetailsTypeSpecialServiceRequestSpecialServiceRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfSpecialReqDetailsTypeSpecialServiceRequestSpecialServiceRequestItem instanceof \dgsoft\StructType\DgSpecialServiceRequest) {
                throw new \InvalidArgumentException(sprintf('The SpecialServiceRequest property can only contain items of \dgsoft\StructType\DgSpecialServiceRequest, "%s" given', is_object($arrayOfSpecialReqDetailsTypeSpecialServiceRequestSpecialServiceRequestItem) ? get_class($arrayOfSpecialReqDetailsTypeSpecialServiceRequestSpecialServiceRequestItem) : gettype($arrayOfSpecialReqDetailsTypeSpecialServiceRequestSpecialServiceRequestItem)), __LINE__);
            }
        }
        $this->SpecialServiceRequest = $specialServiceRequest;
        return $this;
    }
    /**
     * Add item to SpecialServiceRequest value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecialServiceRequest $item
     * @return \dgsoft\ArrayType\DgArrayOfSpecialReqDetailsTypeSpecialServiceRequest
     */
    public function addToSpecialServiceRequest(\dgsoft\StructType\DgSpecialServiceRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSpecialServiceRequest) {
            throw new \InvalidArgumentException(sprintf('The SpecialServiceRequest property can only contain items of \dgsoft\StructType\DgSpecialServiceRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialServiceRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgSpecialServiceRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgSpecialServiceRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgSpecialServiceRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgSpecialServiceRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgSpecialServiceRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SpecialServiceRequest
     */
    public function getAttributeName()
    {
        return 'SpecialServiceRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfSpecialReqDetailsTypeSpecialServiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
