<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServicesTypeService ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfServicesTypeService extends AbstractStructArrayBase
{
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgService[]
     */
    public $Service;
    /**
     * Constructor method for ArrayOfServicesTypeService
     * @uses DgArrayOfServicesTypeService::setService()
     * @param \dgsoft\StructType\DgService[] $service
     */
    public function __construct(array $service = array())
    {
        $this
            ->setService($service);
    }
    /**
     * Get Service value
     * @return \dgsoft\StructType\DgService[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgService[] $service
     * @return \dgsoft\ArrayType\DgArrayOfServicesTypeService
     */
    public function setService(array $service = array())
    {
        foreach ($service as $arrayOfServicesTypeServiceServiceItem) {
            // validation for constraint: itemType
            if (!$arrayOfServicesTypeServiceServiceItem instanceof \dgsoft\StructType\DgService) {
                throw new \InvalidArgumentException(sprintf('The Service property can only contain items of \dgsoft\StructType\DgService, "%s" given', is_object($arrayOfServicesTypeServiceServiceItem) ? get_class($arrayOfServicesTypeServiceServiceItem) : gettype($arrayOfServicesTypeServiceServiceItem)), __LINE__);
            }
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgService $item
     * @return \dgsoft\ArrayType\DgArrayOfServicesTypeService
     */
    public function addToService(\dgsoft\StructType\DgService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgService) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of \dgsoft\StructType\DgService, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgService|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgService|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgService|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgService|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgService|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Service
     */
    public function getAttributeName()
    {
        return 'Service';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfServicesTypeService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
