<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSearchTravelerType ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfSearchTravelerType extends AbstractStructArrayBase
{
    /**
     * The SearchTraveler
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSearchTravelerType[]
     */
    public $SearchTraveler;
    /**
     * Constructor method for ArrayOfSearchTravelerType
     * @uses DgArrayOfSearchTravelerType::setSearchTraveler()
     * @param \dgsoft\StructType\DgSearchTravelerType[] $searchTraveler
     */
    public function __construct(array $searchTraveler = array())
    {
        $this
            ->setSearchTraveler($searchTraveler);
    }
    /**
     * Get SearchTraveler value
     * @return \dgsoft\StructType\DgSearchTravelerType[]|null
     */
    public function getSearchTraveler()
    {
        return $this->SearchTraveler;
    }
    /**
     * Set SearchTraveler value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSearchTravelerType[] $searchTraveler
     * @return \dgsoft\ArrayType\DgArrayOfSearchTravelerType
     */
    public function setSearchTraveler(array $searchTraveler = array())
    {
        foreach ($searchTraveler as $arrayOfSearchTravelerTypeSearchTravelerItem) {
            // validation for constraint: itemType
            if (!$arrayOfSearchTravelerTypeSearchTravelerItem instanceof \dgsoft\StructType\DgSearchTravelerType) {
                throw new \InvalidArgumentException(sprintf('The SearchTraveler property can only contain items of \dgsoft\StructType\DgSearchTravelerType, "%s" given', is_object($arrayOfSearchTravelerTypeSearchTravelerItem) ? get_class($arrayOfSearchTravelerTypeSearchTravelerItem) : gettype($arrayOfSearchTravelerTypeSearchTravelerItem)), __LINE__);
            }
        }
        $this->SearchTraveler = $searchTraveler;
        return $this;
    }
    /**
     * Add item to SearchTraveler value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSearchTravelerType $item
     * @return \dgsoft\ArrayType\DgArrayOfSearchTravelerType
     */
    public function addToSearchTraveler(\dgsoft\StructType\DgSearchTravelerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSearchTravelerType) {
            throw new \InvalidArgumentException(sprintf('The SearchTraveler property can only contain items of \dgsoft\StructType\DgSearchTravelerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SearchTraveler[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgSearchTravelerType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgSearchTravelerType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgSearchTravelerType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgSearchTravelerType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgSearchTravelerType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SearchTraveler
     */
    public function getAttributeName()
    {
        return 'SearchTraveler';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfSearchTravelerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
