<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoomStayTypeRoomRatesRoomRateRestriction ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfRoomStayTypeRoomRatesRoomRateRestriction extends AbstractStructArrayBase
{
    /**
     * The Restriction
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Restriction;
    /**
     * Constructor method for ArrayOfRoomStayTypeRoomRatesRoomRateRestriction
     * @uses DgArrayOfRoomStayTypeRoomRatesRoomRateRestriction::setRestriction()
     * @param string[] $restriction
     */
    public function __construct(array $restriction = array())
    {
        $this
            ->setRestriction($restriction);
    }
    /**
     * Get Restriction value
     * @return string[]|null
     */
    public function getRestriction()
    {
        return $this->Restriction;
    }
    /**
     * Set Restriction value
     * @uses \dgsoft\EnumType\DgRestriction::valueIsValid()
     * @uses \dgsoft\EnumType\DgRestriction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $restriction
     * @return \dgsoft\ArrayType\DgArrayOfRoomStayTypeRoomRatesRoomRateRestriction
     */
    public function setRestriction(array $restriction = array())
    {
        $invalidValues = array();
        foreach ($restriction as $arrayOfRoomStayTypeRoomRatesRoomRateRestrictionRestrictionItem) {
            if (!\dgsoft\EnumType\DgRestriction::valueIsValid($arrayOfRoomStayTypeRoomRatesRoomRateRestrictionRestrictionItem)) {
                $invalidValues[] = var_export($arrayOfRoomStayTypeRoomRatesRoomRateRestrictionRestrictionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \dgsoft\EnumType\DgRestriction::getValidValues())), __LINE__);
        }
        $this->Restriction = $restriction;
        return $this;
    }
    /**
     * Add item to Restriction value
     * @uses \dgsoft\EnumType\DgRestriction::valueIsValid()
     * @uses \dgsoft\EnumType\DgRestriction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\ArrayType\DgArrayOfRoomStayTypeRoomRatesRoomRateRestriction
     */
    public function addToRestriction($item)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgRestriction::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \dgsoft\EnumType\DgRestriction::getValidValues())), __LINE__);
        }
        $this->Restriction[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \dgsoft\EnumType\DgRestriction::valueIsValid()
     * @param string $item
     * @return \dgsoft\ArrayType\DgArrayOfRoomStayTypeRoomRatesRoomRateRestriction
     */
    public function add($item)
    {
        if (!\dgsoft\EnumType\DgRestriction::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \dgsoft\EnumType\DgRestriction::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Restriction
     */
    public function getAttributeName()
    {
        return 'Restriction';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfRoomStayTypeRoomRatesRoomRateRestriction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
