<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoomAmenityPrefType ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfRoomAmenityPrefType extends AbstractStructArrayBase
{
    /**
     * The Amenity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRoomAmenityPrefType[]
     */
    public $Amenity;
    /**
     * Constructor method for ArrayOfRoomAmenityPrefType
     * @uses DgArrayOfRoomAmenityPrefType::setAmenity()
     * @param \dgsoft\StructType\DgRoomAmenityPrefType[] $amenity
     */
    public function __construct(array $amenity = array())
    {
        $this
            ->setAmenity($amenity);
    }
    /**
     * Get Amenity value
     * @return \dgsoft\StructType\DgRoomAmenityPrefType[]|null
     */
    public function getAmenity()
    {
        return $this->Amenity;
    }
    /**
     * Set Amenity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRoomAmenityPrefType[] $amenity
     * @return \dgsoft\ArrayType\DgArrayOfRoomAmenityPrefType
     */
    public function setAmenity(array $amenity = array())
    {
        foreach ($amenity as $arrayOfRoomAmenityPrefTypeAmenityItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoomAmenityPrefTypeAmenityItem instanceof \dgsoft\StructType\DgRoomAmenityPrefType) {
                throw new \InvalidArgumentException(sprintf('The Amenity property can only contain items of \dgsoft\StructType\DgRoomAmenityPrefType, "%s" given', is_object($arrayOfRoomAmenityPrefTypeAmenityItem) ? get_class($arrayOfRoomAmenityPrefTypeAmenityItem) : gettype($arrayOfRoomAmenityPrefTypeAmenityItem)), __LINE__);
            }
        }
        $this->Amenity = $amenity;
        return $this;
    }
    /**
     * Add item to Amenity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRoomAmenityPrefType $item
     * @return \dgsoft\ArrayType\DgArrayOfRoomAmenityPrefType
     */
    public function addToAmenity(\dgsoft\StructType\DgRoomAmenityPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRoomAmenityPrefType) {
            throw new \InvalidArgumentException(sprintf('The Amenity property can only contain items of \dgsoft\StructType\DgRoomAmenityPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Amenity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgRoomAmenityPrefType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgRoomAmenityPrefType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgRoomAmenityPrefType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgRoomAmenityPrefType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgRoomAmenityPrefType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Amenity
     */
    public function getAttributeName()
    {
        return 'Amenity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfRoomAmenityPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
