<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfQueueSetting ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfQueueSetting extends AbstractStructArrayBase
{
    /**
     * The QueueSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgQueueSetting[]
     */
    public $QueueSetting;
    /**
     * Constructor method for ArrayOfQueueSetting
     * @uses DgArrayOfQueueSetting::setQueueSetting()
     * @param \dgsoft\StructType\DgQueueSetting[] $queueSetting
     */
    public function __construct(array $queueSetting = array())
    {
        $this
            ->setQueueSetting($queueSetting);
    }
    /**
     * Get QueueSetting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgQueueSetting[]|null
     */
    public function getQueueSetting()
    {
        return isset($this->QueueSetting) ? $this->QueueSetting : null;
    }
    /**
     * Set QueueSetting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgQueueSetting[] $queueSetting
     * @return \dgsoft\ArrayType\DgArrayOfQueueSetting
     */
    public function setQueueSetting(array $queueSetting = array())
    {
        foreach ($queueSetting as $arrayOfQueueSettingQueueSettingItem) {
            // validation for constraint: itemType
            if (!$arrayOfQueueSettingQueueSettingItem instanceof \dgsoft\StructType\DgQueueSetting) {
                throw new \InvalidArgumentException(sprintf('The QueueSetting property can only contain items of \dgsoft\StructType\DgQueueSetting, "%s" given', is_object($arrayOfQueueSettingQueueSettingItem) ? get_class($arrayOfQueueSettingQueueSettingItem) : gettype($arrayOfQueueSettingQueueSettingItem)), __LINE__);
            }
        }
        if (is_null($queueSetting) || (is_array($queueSetting) && empty($queueSetting))) {
            unset($this->QueueSetting);
        } else {
            $this->QueueSetting = $queueSetting;
        }
        return $this;
    }
    /**
     * Add item to QueueSetting value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgQueueSetting $item
     * @return \dgsoft\ArrayType\DgArrayOfQueueSetting
     */
    public function addToQueueSetting(\dgsoft\StructType\DgQueueSetting $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgQueueSetting) {
            throw new \InvalidArgumentException(sprintf('The QueueSetting property can only contain items of \dgsoft\StructType\DgQueueSetting, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->QueueSetting[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgQueueSetting|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgQueueSetting|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgQueueSetting|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgQueueSetting|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgQueueSetting|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string QueueSetting
     */
    public function getAttributeName()
    {
        return 'QueueSetting';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfQueueSetting
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
