<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProfileType ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfProfileType extends AbstractStructArrayBase
{
    /**
     * The Profile
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgProfileType[]
     */
    public $Profile;
    /**
     * Constructor method for ArrayOfProfileType
     * @uses DgArrayOfProfileType::setProfile()
     * @param \dgsoft\StructType\DgProfileType[] $profile
     */
    public function __construct(array $profile = array())
    {
        $this
            ->setProfile($profile);
    }
    /**
     * Get Profile value
     * @return \dgsoft\StructType\DgProfileType[]|null
     */
    public function getProfile()
    {
        return $this->Profile;
    }
    /**
     * Set Profile value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgProfileType[] $profile
     * @return \dgsoft\ArrayType\DgArrayOfProfileType
     */
    public function setProfile(array $profile = array())
    {
        foreach ($profile as $arrayOfProfileTypeProfileItem) {
            // validation for constraint: itemType
            if (!$arrayOfProfileTypeProfileItem instanceof \dgsoft\StructType\DgProfileType) {
                throw new \InvalidArgumentException(sprintf('The Profile property can only contain items of \dgsoft\StructType\DgProfileType, "%s" given', is_object($arrayOfProfileTypeProfileItem) ? get_class($arrayOfProfileTypeProfileItem) : gettype($arrayOfProfileTypeProfileItem)), __LINE__);
            }
        }
        $this->Profile = $profile;
        return $this;
    }
    /**
     * Add item to Profile value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgProfileType $item
     * @return \dgsoft\ArrayType\DgArrayOfProfileType
     */
    public function addToProfile(\dgsoft\StructType\DgProfileType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgProfileType) {
            throw new \InvalidArgumentException(sprintf('The Profile property can only contain items of \dgsoft\StructType\DgProfileType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Profile[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgProfileType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgProfileType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgProfileType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgProfileType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgProfileType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Profile
     */
    public function getAttributeName()
    {
        return 'Profile';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfProfileType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
