<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentFormType ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfPaymentFormType extends AbstractStructArrayBase
{
    /**
     * The AcceptedPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentFormType[]
     */
    public $AcceptedPayment;
    /**
     * Constructor method for ArrayOfPaymentFormType
     * @uses DgArrayOfPaymentFormType::setAcceptedPayment()
     * @param \dgsoft\StructType\DgPaymentFormType[] $acceptedPayment
     */
    public function __construct(array $acceptedPayment = array())
    {
        $this
            ->setAcceptedPayment($acceptedPayment);
    }
    /**
     * Get AcceptedPayment value
     * @return \dgsoft\StructType\DgPaymentFormType[]|null
     */
    public function getAcceptedPayment()
    {
        return $this->AcceptedPayment;
    }
    /**
     * Set AcceptedPayment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormType[] $acceptedPayment
     * @return \dgsoft\ArrayType\DgArrayOfPaymentFormType
     */
    public function setAcceptedPayment(array $acceptedPayment = array())
    {
        foreach ($acceptedPayment as $arrayOfPaymentFormTypeAcceptedPaymentItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentFormTypeAcceptedPaymentItem instanceof \dgsoft\StructType\DgPaymentFormType) {
                throw new \InvalidArgumentException(sprintf('The AcceptedPayment property can only contain items of \dgsoft\StructType\DgPaymentFormType, "%s" given', is_object($arrayOfPaymentFormTypeAcceptedPaymentItem) ? get_class($arrayOfPaymentFormTypeAcceptedPaymentItem) : gettype($arrayOfPaymentFormTypeAcceptedPaymentItem)), __LINE__);
            }
        }
        $this->AcceptedPayment = $acceptedPayment;
        return $this;
    }
    /**
     * Add item to AcceptedPayment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormType $item
     * @return \dgsoft\ArrayType\DgArrayOfPaymentFormType
     */
    public function addToAcceptedPayment(\dgsoft\StructType\DgPaymentFormType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPaymentFormType) {
            throw new \InvalidArgumentException(sprintf('The AcceptedPayment property can only contain items of \dgsoft\StructType\DgPaymentFormType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AcceptedPayment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgPaymentFormType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgPaymentFormType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgPaymentFormType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgPaymentFormType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgPaymentFormType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AcceptedPayment
     */
    public function getAttributeName()
    {
        return 'AcceptedPayment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfPaymentFormType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
