<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPassengerDB ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfPassengerDB extends AbstractStructArrayBase
{
    /**
     * The PassengerDB
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgPassengerDB[]
     */
    public $PassengerDB;
    /**
     * Constructor method for ArrayOfPassengerDB
     * @uses DgArrayOfPassengerDB::setPassengerDB()
     * @param \dgsoft\StructType\DgPassengerDB[] $passengerDB
     */
    public function __construct(array $passengerDB = array())
    {
        $this
            ->setPassengerDB($passengerDB);
    }
    /**
     * Get PassengerDB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgPassengerDB[]|null
     */
    public function getPassengerDB()
    {
        return isset($this->PassengerDB) ? $this->PassengerDB : null;
    }
    /**
     * Set PassengerDB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPassengerDB[] $passengerDB
     * @return \dgsoft\ArrayType\DgArrayOfPassengerDB
     */
    public function setPassengerDB(array $passengerDB = array())
    {
        foreach ($passengerDB as $arrayOfPassengerDBPassengerDBItem) {
            // validation for constraint: itemType
            if (!$arrayOfPassengerDBPassengerDBItem instanceof \dgsoft\StructType\DgPassengerDB) {
                throw new \InvalidArgumentException(sprintf('The PassengerDB property can only contain items of \dgsoft\StructType\DgPassengerDB, "%s" given', is_object($arrayOfPassengerDBPassengerDBItem) ? get_class($arrayOfPassengerDBPassengerDBItem) : gettype($arrayOfPassengerDBPassengerDBItem)), __LINE__);
            }
        }
        if (is_null($passengerDB) || (is_array($passengerDB) && empty($passengerDB))) {
            unset($this->PassengerDB);
        } else {
            $this->PassengerDB = $passengerDB;
        }
        return $this;
    }
    /**
     * Add item to PassengerDB value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPassengerDB $item
     * @return \dgsoft\ArrayType\DgArrayOfPassengerDB
     */
    public function addToPassengerDB(\dgsoft\StructType\DgPassengerDB $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPassengerDB) {
            throw new \InvalidArgumentException(sprintf('The PassengerDB property can only contain items of \dgsoft\StructType\DgPassengerDB, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PassengerDB[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgPassengerDB|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgPassengerDB|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgPassengerDB|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgPassengerDB|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgPassengerDB|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PassengerDB
     */
    public function getAttributeName()
    {
        return 'PassengerDB';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfPassengerDB
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
