<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPNRRemarkInfo ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfPNRRemarkInfo extends AbstractStructArrayBase
{
    /**
     * The PNRRemark
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgPNRRemarkInfo[]
     */
    public $PNRRemark;
    /**
     * Constructor method for ArrayOfPNRRemarkInfo
     * @uses DgArrayOfPNRRemarkInfo::setPNRRemark()
     * @param \dgsoft\StructType\DgPNRRemarkInfo[] $pNRRemark
     */
    public function __construct(array $pNRRemark = array())
    {
        $this
            ->setPNRRemark($pNRRemark);
    }
    /**
     * Get PNRRemark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgPNRRemarkInfo[]|null
     */
    public function getPNRRemark()
    {
        return isset($this->PNRRemark) ? $this->PNRRemark : null;
    }
    /**
     * Set PNRRemark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPNRRemarkInfo[] $pNRRemark
     * @return \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo
     */
    public function setPNRRemark(array $pNRRemark = array())
    {
        foreach ($pNRRemark as $arrayOfPNRRemarkInfoPNRRemarkItem) {
            // validation for constraint: itemType
            if (!$arrayOfPNRRemarkInfoPNRRemarkItem instanceof \dgsoft\StructType\DgPNRRemarkInfo) {
                throw new \InvalidArgumentException(sprintf('The PNRRemark property can only contain items of \dgsoft\StructType\DgPNRRemarkInfo, "%s" given', is_object($arrayOfPNRRemarkInfoPNRRemarkItem) ? get_class($arrayOfPNRRemarkInfoPNRRemarkItem) : gettype($arrayOfPNRRemarkInfoPNRRemarkItem)), __LINE__);
            }
        }
        if (is_null($pNRRemark) || (is_array($pNRRemark) && empty($pNRRemark))) {
            unset($this->PNRRemark);
        } else {
            $this->PNRRemark = $pNRRemark;
        }
        return $this;
    }
    /**
     * Add item to PNRRemark value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPNRRemarkInfo $item
     * @return \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo
     */
    public function addToPNRRemark(\dgsoft\StructType\DgPNRRemarkInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPNRRemarkInfo) {
            throw new \InvalidArgumentException(sprintf('The PNRRemark property can only contain items of \dgsoft\StructType\DgPNRRemarkInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PNRRemark[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgPNRRemarkInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgPNRRemarkInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgPNRRemarkInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgPNRRemarkInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgPNRRemarkInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PNRRemark
     */
    public function getAttributeName()
    {
        return 'PNRRemark';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
