<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOriginDestinationInformationTypeDestinationLocation
 * ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfOriginDestinationInformationTypeDestinationLocation extends AbstractStructArrayBase
{
    /**
     * The DestinationLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDestinationLocation[]
     */
    public $DestinationLocation;
    /**
     * Constructor method for
     * ArrayOfOriginDestinationInformationTypeDestinationLocation
     * @uses DgArrayOfOriginDestinationInformationTypeDestinationLocation::setDestinationLocation()
     * @param \dgsoft\StructType\DgDestinationLocation[] $destinationLocation
     */
    public function __construct(array $destinationLocation = array())
    {
        $this
            ->setDestinationLocation($destinationLocation);
    }
    /**
     * Get DestinationLocation value
     * @return \dgsoft\StructType\DgDestinationLocation[]|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDestinationLocation[] $destinationLocation
     * @return \dgsoft\ArrayType\DgArrayOfOriginDestinationInformationTypeDestinationLocation
     */
    public function setDestinationLocation(array $destinationLocation = array())
    {
        foreach ($destinationLocation as $arrayOfOriginDestinationInformationTypeDestinationLocationDestinationLocationItem) {
            // validation for constraint: itemType
            if (!$arrayOfOriginDestinationInformationTypeDestinationLocationDestinationLocationItem instanceof \dgsoft\StructType\DgDestinationLocation) {
                throw new \InvalidArgumentException(sprintf('The DestinationLocation property can only contain items of \dgsoft\StructType\DgDestinationLocation, "%s" given', is_object($arrayOfOriginDestinationInformationTypeDestinationLocationDestinationLocationItem) ? get_class($arrayOfOriginDestinationInformationTypeDestinationLocationDestinationLocationItem) : gettype($arrayOfOriginDestinationInformationTypeDestinationLocationDestinationLocationItem)), __LINE__);
            }
        }
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Add item to DestinationLocation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDestinationLocation $item
     * @return \dgsoft\ArrayType\DgArrayOfOriginDestinationInformationTypeDestinationLocation
     */
    public function addToDestinationLocation(\dgsoft\StructType\DgDestinationLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgDestinationLocation) {
            throw new \InvalidArgumentException(sprintf('The DestinationLocation property can only contain items of \dgsoft\StructType\DgDestinationLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DestinationLocation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgDestinationLocation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgDestinationLocation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgDestinationLocation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgDestinationLocation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgDestinationLocation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DestinationLocation
     */
    public function getAttributeName()
    {
        return 'DestinationLocation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfOriginDestinationInformationTypeDestinationLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
