<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOSIelement ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfOSIelement extends AbstractStructArrayBase
{
    /**
     * The OSIelement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgOSIelement[]
     */
    public $OSIelement;
    /**
     * Constructor method for ArrayOfOSIelement
     * @uses DgArrayOfOSIelement::setOSIelement()
     * @param \dgsoft\StructType\DgOSIelement[] $oSIelement
     */
    public function __construct(array $oSIelement = array())
    {
        $this
            ->setOSIelement($oSIelement);
    }
    /**
     * Get OSIelement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgOSIelement[]|null
     */
    public function getOSIelement()
    {
        return isset($this->OSIelement) ? $this->OSIelement : null;
    }
    /**
     * Set OSIelement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOSIelement[] $oSIelement
     * @return \dgsoft\ArrayType\DgArrayOfOSIelement
     */
    public function setOSIelement(array $oSIelement = array())
    {
        foreach ($oSIelement as $arrayOfOSIelementOSIelementItem) {
            // validation for constraint: itemType
            if (!$arrayOfOSIelementOSIelementItem instanceof \dgsoft\StructType\DgOSIelement) {
                throw new \InvalidArgumentException(sprintf('The OSIelement property can only contain items of \dgsoft\StructType\DgOSIelement, "%s" given', is_object($arrayOfOSIelementOSIelementItem) ? get_class($arrayOfOSIelementOSIelementItem) : gettype($arrayOfOSIelementOSIelementItem)), __LINE__);
            }
        }
        if (is_null($oSIelement) || (is_array($oSIelement) && empty($oSIelement))) {
            unset($this->OSIelement);
        } else {
            $this->OSIelement = $oSIelement;
        }
        return $this;
    }
    /**
     * Add item to OSIelement value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOSIelement $item
     * @return \dgsoft\ArrayType\DgArrayOfOSIelement
     */
    public function addToOSIelement(\dgsoft\StructType\DgOSIelement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOSIelement) {
            throw new \InvalidArgumentException(sprintf('The OSIelement property can only contain items of \dgsoft\StructType\DgOSIelement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OSIelement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgOSIelement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgOSIelement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgOSIelement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgOSIelement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgOSIelement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OSIelement
     */
    public function getAttributeName()
    {
        return 'OSIelement';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfOSIelement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
