<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMonetaryRuleType ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfMonetaryRuleType extends AbstractStructArrayBase
{
    /**
     * The PaymentRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMonetaryRuleType[]
     */
    public $PaymentRule;
    /**
     * Constructor method for ArrayOfMonetaryRuleType
     * @uses DgArrayOfMonetaryRuleType::setPaymentRule()
     * @param \dgsoft\StructType\DgMonetaryRuleType[] $paymentRule
     */
    public function __construct(array $paymentRule = array())
    {
        $this
            ->setPaymentRule($paymentRule);
    }
    /**
     * Get PaymentRule value
     * @return \dgsoft\StructType\DgMonetaryRuleType[]|null
     */
    public function getPaymentRule()
    {
        return $this->PaymentRule;
    }
    /**
     * Set PaymentRule value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMonetaryRuleType[] $paymentRule
     * @return \dgsoft\ArrayType\DgArrayOfMonetaryRuleType
     */
    public function setPaymentRule(array $paymentRule = array())
    {
        foreach ($paymentRule as $arrayOfMonetaryRuleTypePaymentRuleItem) {
            // validation for constraint: itemType
            if (!$arrayOfMonetaryRuleTypePaymentRuleItem instanceof \dgsoft\StructType\DgMonetaryRuleType) {
                throw new \InvalidArgumentException(sprintf('The PaymentRule property can only contain items of \dgsoft\StructType\DgMonetaryRuleType, "%s" given', is_object($arrayOfMonetaryRuleTypePaymentRuleItem) ? get_class($arrayOfMonetaryRuleTypePaymentRuleItem) : gettype($arrayOfMonetaryRuleTypePaymentRuleItem)), __LINE__);
            }
        }
        $this->PaymentRule = $paymentRule;
        return $this;
    }
    /**
     * Add item to PaymentRule value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMonetaryRuleType $item
     * @return \dgsoft\ArrayType\DgArrayOfMonetaryRuleType
     */
    public function addToPaymentRule(\dgsoft\StructType\DgMonetaryRuleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgMonetaryRuleType) {
            throw new \InvalidArgumentException(sprintf('The PaymentRule property can only contain items of \dgsoft\StructType\DgMonetaryRuleType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentRule[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgMonetaryRuleType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgMonetaryRuleType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgMonetaryRuleType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgMonetaryRuleType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgMonetaryRuleType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentRule
     */
    public function getAttributeName()
    {
        return 'PaymentRule';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfMonetaryRuleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
