<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLCCSupportedCard ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfLCCSupportedCard extends AbstractStructArrayBase
{
    /**
     * The LCCSupportedCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgLCCSupportedCard[]
     */
    public $LCCSupportedCard;
    /**
     * Constructor method for ArrayOfLCCSupportedCard
     * @uses DgArrayOfLCCSupportedCard::setLCCSupportedCard()
     * @param \dgsoft\StructType\DgLCCSupportedCard[] $lCCSupportedCard
     */
    public function __construct(array $lCCSupportedCard = array())
    {
        $this
            ->setLCCSupportedCard($lCCSupportedCard);
    }
    /**
     * Get LCCSupportedCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgLCCSupportedCard[]|null
     */
    public function getLCCSupportedCard()
    {
        return isset($this->LCCSupportedCard) ? $this->LCCSupportedCard : null;
    }
    /**
     * Set LCCSupportedCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLCCSupportedCard[] $lCCSupportedCard
     * @return \dgsoft\ArrayType\DgArrayOfLCCSupportedCard
     */
    public function setLCCSupportedCard(array $lCCSupportedCard = array())
    {
        foreach ($lCCSupportedCard as $arrayOfLCCSupportedCardLCCSupportedCardItem) {
            // validation for constraint: itemType
            if (!$arrayOfLCCSupportedCardLCCSupportedCardItem instanceof \dgsoft\StructType\DgLCCSupportedCard) {
                throw new \InvalidArgumentException(sprintf('The LCCSupportedCard property can only contain items of \dgsoft\StructType\DgLCCSupportedCard, "%s" given', is_object($arrayOfLCCSupportedCardLCCSupportedCardItem) ? get_class($arrayOfLCCSupportedCardLCCSupportedCardItem) : gettype($arrayOfLCCSupportedCardLCCSupportedCardItem)), __LINE__);
            }
        }
        if (is_null($lCCSupportedCard) || (is_array($lCCSupportedCard) && empty($lCCSupportedCard))) {
            unset($this->LCCSupportedCard);
        } else {
            $this->LCCSupportedCard = $lCCSupportedCard;
        }
        return $this;
    }
    /**
     * Add item to LCCSupportedCard value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLCCSupportedCard $item
     * @return \dgsoft\ArrayType\DgArrayOfLCCSupportedCard
     */
    public function addToLCCSupportedCard(\dgsoft\StructType\DgLCCSupportedCard $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgLCCSupportedCard) {
            throw new \InvalidArgumentException(sprintf('The LCCSupportedCard property can only contain items of \dgsoft\StructType\DgLCCSupportedCard, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LCCSupportedCard[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgLCCSupportedCard|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgLCCSupportedCard|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgLCCSupportedCard|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgLCCSupportedCard|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgLCCSupportedCard|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LCCSupportedCard
     */
    public function getAttributeName()
    {
        return 'LCCSupportedCard';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfLCCSupportedCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
