<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFareFamily ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfFareFamily extends AbstractStructArrayBase
{
    /**
     * The FareFamily
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgFareFamily[]
     */
    public $FareFamily;
    /**
     * Constructor method for ArrayOfFareFamily
     * @uses DgArrayOfFareFamily::setFareFamily()
     * @param \dgsoft\StructType\DgFareFamily[] $fareFamily
     */
    public function __construct(array $fareFamily = array())
    {
        $this
            ->setFareFamily($fareFamily);
    }
    /**
     * Get FareFamily value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgFareFamily[]|null
     */
    public function getFareFamily()
    {
        return isset($this->FareFamily) ? $this->FareFamily : null;
    }
    /**
     * Set FareFamily value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareFamily[] $fareFamily
     * @return \dgsoft\ArrayType\DgArrayOfFareFamily
     */
    public function setFareFamily(array $fareFamily = array())
    {
        foreach ($fareFamily as $arrayOfFareFamilyFareFamilyItem) {
            // validation for constraint: itemType
            if (!$arrayOfFareFamilyFareFamilyItem instanceof \dgsoft\StructType\DgFareFamily) {
                throw new \InvalidArgumentException(sprintf('The FareFamily property can only contain items of \dgsoft\StructType\DgFareFamily, "%s" given', is_object($arrayOfFareFamilyFareFamilyItem) ? get_class($arrayOfFareFamilyFareFamilyItem) : gettype($arrayOfFareFamilyFareFamilyItem)), __LINE__);
            }
        }
        if (is_null($fareFamily) || (is_array($fareFamily) && empty($fareFamily))) {
            unset($this->FareFamily);
        } else {
            $this->FareFamily = $fareFamily;
        }
        return $this;
    }
    /**
     * Add item to FareFamily value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareFamily $item
     * @return \dgsoft\ArrayType\DgArrayOfFareFamily
     */
    public function addToFareFamily(\dgsoft\StructType\DgFareFamily $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFareFamily) {
            throw new \InvalidArgumentException(sprintf('The FareFamily property can only contain items of \dgsoft\StructType\DgFareFamily, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareFamily[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgFareFamily|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgFareFamily|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgFareFamily|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgFareFamily|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgFareFamily|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FareFamily
     */
    public function getAttributeName()
    {
        return 'FareFamily';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfFareFamily
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
