<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfETicketInfo ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfETicketInfo extends AbstractStructArrayBase
{
    /**
     * The ETicketInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgETicketInfo[]
     */
    public $ETicketInfo;
    /**
     * Constructor method for ArrayOfETicketInfo
     * @uses DgArrayOfETicketInfo::setETicketInfo()
     * @param \dgsoft\StructType\DgETicketInfo[] $eTicketInfo
     */
    public function __construct(array $eTicketInfo = array())
    {
        $this
            ->setETicketInfo($eTicketInfo);
    }
    /**
     * Get ETicketInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgETicketInfo[]|null
     */
    public function getETicketInfo()
    {
        return isset($this->ETicketInfo) ? $this->ETicketInfo : null;
    }
    /**
     * Set ETicketInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgETicketInfo[] $eTicketInfo
     * @return \dgsoft\ArrayType\DgArrayOfETicketInfo
     */
    public function setETicketInfo(array $eTicketInfo = array())
    {
        foreach ($eTicketInfo as $arrayOfETicketInfoETicketInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfETicketInfoETicketInfoItem instanceof \dgsoft\StructType\DgETicketInfo) {
                throw new \InvalidArgumentException(sprintf('The ETicketInfo property can only contain items of \dgsoft\StructType\DgETicketInfo, "%s" given', is_object($arrayOfETicketInfoETicketInfoItem) ? get_class($arrayOfETicketInfoETicketInfoItem) : gettype($arrayOfETicketInfoETicketInfoItem)), __LINE__);
            }
        }
        if (is_null($eTicketInfo) || (is_array($eTicketInfo) && empty($eTicketInfo))) {
            unset($this->ETicketInfo);
        } else {
            $this->ETicketInfo = $eTicketInfo;
        }
        return $this;
    }
    /**
     * Add item to ETicketInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgETicketInfo $item
     * @return \dgsoft\ArrayType\DgArrayOfETicketInfo
     */
    public function addToETicketInfo(\dgsoft\StructType\DgETicketInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgETicketInfo) {
            throw new \InvalidArgumentException(sprintf('The ETicketInfo property can only contain items of \dgsoft\StructType\DgETicketInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ETicketInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgETicketInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgETicketInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgETicketInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgETicketInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgETicketInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ETicketInfo
     */
    public function getAttributeName()
    {
        return 'ETicketInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfETicketInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
