<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocument ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfDocument extends AbstractStructArrayBase
{
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgDocument[]
     */
    public $Document;
    /**
     * Constructor method for ArrayOfDocument
     * @uses DgArrayOfDocument::setDocument()
     * @param \dgsoft\StructType\DgDocument[] $document
     */
    public function __construct(array $document = array())
    {
        $this
            ->setDocument($document);
    }
    /**
     * Get Document value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgDocument[]|null
     */
    public function getDocument()
    {
        return isset($this->Document) ? $this->Document : null;
    }
    /**
     * Set Document value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDocument[] $document
     * @return \dgsoft\ArrayType\DgArrayOfDocument
     */
    public function setDocument(array $document = array())
    {
        foreach ($document as $arrayOfDocumentDocumentItem) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentDocumentItem instanceof \dgsoft\StructType\DgDocument) {
                throw new \InvalidArgumentException(sprintf('The Document property can only contain items of \dgsoft\StructType\DgDocument, "%s" given', is_object($arrayOfDocumentDocumentItem) ? get_class($arrayOfDocumentDocumentItem) : gettype($arrayOfDocumentDocumentItem)), __LINE__);
            }
        }
        if (is_null($document) || (is_array($document) && empty($document))) {
            unset($this->Document);
        } else {
            $this->Document = $document;
        }
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDocument $item
     * @return \dgsoft\ArrayType\DgArrayOfDocument
     */
    public function addToDocument(\dgsoft\StructType\DgDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgDocument) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of \dgsoft\StructType\DgDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgDocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgDocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgDocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgDocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgDocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Document
     */
    public function getAttributeName()
    {
        return 'Document';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
