<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCompanyNameType ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfCompanyNameType extends AbstractStructArrayBase
{
    /**
     * The Operator
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType[]
     */
    public $Operator;
    /**
     * Constructor method for ArrayOfCompanyNameType
     * @uses DgArrayOfCompanyNameType::setOperator()
     * @param \dgsoft\StructType\DgCompanyNameType[] $operator
     */
    public function __construct(array $operator = array())
    {
        $this
            ->setOperator($operator);
    }
    /**
     * Get Operator value
     * @return \dgsoft\StructType\DgCompanyNameType[]|null
     */
    public function getOperator()
    {
        return $this->Operator;
    }
    /**
     * Set Operator value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType[] $operator
     * @return \dgsoft\ArrayType\DgArrayOfCompanyNameType
     */
    public function setOperator(array $operator = array())
    {
        foreach ($operator as $arrayOfCompanyNameTypeOperatorItem) {
            // validation for constraint: itemType
            if (!$arrayOfCompanyNameTypeOperatorItem instanceof \dgsoft\StructType\DgCompanyNameType) {
                throw new \InvalidArgumentException(sprintf('The Operator property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($arrayOfCompanyNameTypeOperatorItem) ? get_class($arrayOfCompanyNameTypeOperatorItem) : gettype($arrayOfCompanyNameTypeOperatorItem)), __LINE__);
            }
        }
        $this->Operator = $operator;
        return $this;
    }
    /**
     * Add item to Operator value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType $item
     * @return \dgsoft\ArrayType\DgArrayOfCompanyNameType
     */
    public function addToOperator(\dgsoft\StructType\DgCompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The Operator property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Operator[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Operator
     */
    public function getAttributeName()
    {
        return 'Operator';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfCompanyNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
