<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCommunicationHint ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfCommunicationHint extends AbstractStructArrayBase
{
    /**
     * The CommunicationHint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgCommunicationHint[]
     */
    public $CommunicationHint;
    /**
     * Constructor method for ArrayOfCommunicationHint
     * @uses DgArrayOfCommunicationHint::setCommunicationHint()
     * @param \dgsoft\StructType\DgCommunicationHint[] $communicationHint
     */
    public function __construct(array $communicationHint = array())
    {
        $this
            ->setCommunicationHint($communicationHint);
    }
    /**
     * Get CommunicationHint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgCommunicationHint[]|null
     */
    public function getCommunicationHint()
    {
        return isset($this->CommunicationHint) ? $this->CommunicationHint : null;
    }
    /**
     * Set CommunicationHint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCommunicationHint[] $communicationHint
     * @return \dgsoft\ArrayType\DgArrayOfCommunicationHint
     */
    public function setCommunicationHint(array $communicationHint = array())
    {
        foreach ($communicationHint as $arrayOfCommunicationHintCommunicationHintItem) {
            // validation for constraint: itemType
            if (!$arrayOfCommunicationHintCommunicationHintItem instanceof \dgsoft\StructType\DgCommunicationHint) {
                throw new \InvalidArgumentException(sprintf('The CommunicationHint property can only contain items of \dgsoft\StructType\DgCommunicationHint, "%s" given', is_object($arrayOfCommunicationHintCommunicationHintItem) ? get_class($arrayOfCommunicationHintCommunicationHintItem) : gettype($arrayOfCommunicationHintCommunicationHintItem)), __LINE__);
            }
        }
        if (is_null($communicationHint) || (is_array($communicationHint) && empty($communicationHint))) {
            unset($this->CommunicationHint);
        } else {
            $this->CommunicationHint = $communicationHint;
        }
        return $this;
    }
    /**
     * Add item to CommunicationHint value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCommunicationHint $item
     * @return \dgsoft\ArrayType\DgArrayOfCommunicationHint
     */
    public function addToCommunicationHint(\dgsoft\StructType\DgCommunicationHint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCommunicationHint) {
            throw new \InvalidArgumentException(sprintf('The CommunicationHint property can only contain items of \dgsoft\StructType\DgCommunicationHint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CommunicationHint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgCommunicationHint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgCommunicationHint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgCommunicationHint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgCommunicationHint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgCommunicationHint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CommunicationHint
     */
    public function getAttributeName()
    {
        return 'CommunicationHint';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfCommunicationHint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
