<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCommunication ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfCommunication extends AbstractStructArrayBase
{
    /**
     * The Communication
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgCommunication[]
     */
    public $Communication;
    /**
     * Constructor method for ArrayOfCommunication
     * @uses DgArrayOfCommunication::setCommunication()
     * @param \dgsoft\StructType\DgCommunication[] $communication
     */
    public function __construct(array $communication = array())
    {
        $this
            ->setCommunication($communication);
    }
    /**
     * Get Communication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgCommunication[]|null
     */
    public function getCommunication()
    {
        return isset($this->Communication) ? $this->Communication : null;
    }
    /**
     * Set Communication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCommunication[] $communication
     * @return \dgsoft\ArrayType\DgArrayOfCommunication
     */
    public function setCommunication(array $communication = array())
    {
        foreach ($communication as $arrayOfCommunicationCommunicationItem) {
            // validation for constraint: itemType
            if (!$arrayOfCommunicationCommunicationItem instanceof \dgsoft\StructType\DgCommunication) {
                throw new \InvalidArgumentException(sprintf('The Communication property can only contain items of \dgsoft\StructType\DgCommunication, "%s" given', is_object($arrayOfCommunicationCommunicationItem) ? get_class($arrayOfCommunicationCommunicationItem) : gettype($arrayOfCommunicationCommunicationItem)), __LINE__);
            }
        }
        if (is_null($communication) || (is_array($communication) && empty($communication))) {
            unset($this->Communication);
        } else {
            $this->Communication = $communication;
        }
        return $this;
    }
    /**
     * Add item to Communication value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCommunication $item
     * @return \dgsoft\ArrayType\DgArrayOfCommunication
     */
    public function addToCommunication(\dgsoft\StructType\DgCommunication $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCommunication) {
            throw new \InvalidArgumentException(sprintf('The Communication property can only contain items of \dgsoft\StructType\DgCommunication, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Communication[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgCommunication|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgCommunication|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgCommunication|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgCommunication|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgCommunication|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Communication
     */
    public function getAttributeName()
    {
        return 'Communication';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfCommunication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
