<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfChangeDetail ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfChangeDetail extends AbstractStructArrayBase
{
    /**
     * The ChangeDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgChangeDetail[]
     */
    public $ChangeDetail;
    /**
     * Constructor method for ArrayOfChangeDetail
     * @uses DgArrayOfChangeDetail::setChangeDetail()
     * @param \dgsoft\StructType\DgChangeDetail[] $changeDetail
     */
    public function __construct(array $changeDetail = array())
    {
        $this
            ->setChangeDetail($changeDetail);
    }
    /**
     * Get ChangeDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgChangeDetail[]|null
     */
    public function getChangeDetail()
    {
        return isset($this->ChangeDetail) ? $this->ChangeDetail : null;
    }
    /**
     * Set ChangeDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgChangeDetail[] $changeDetail
     * @return \dgsoft\ArrayType\DgArrayOfChangeDetail
     */
    public function setChangeDetail(array $changeDetail = array())
    {
        foreach ($changeDetail as $arrayOfChangeDetailChangeDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfChangeDetailChangeDetailItem instanceof \dgsoft\StructType\DgChangeDetail) {
                throw new \InvalidArgumentException(sprintf('The ChangeDetail property can only contain items of \dgsoft\StructType\DgChangeDetail, "%s" given', is_object($arrayOfChangeDetailChangeDetailItem) ? get_class($arrayOfChangeDetailChangeDetailItem) : gettype($arrayOfChangeDetailChangeDetailItem)), __LINE__);
            }
        }
        if (is_null($changeDetail) || (is_array($changeDetail) && empty($changeDetail))) {
            unset($this->ChangeDetail);
        } else {
            $this->ChangeDetail = $changeDetail;
        }
        return $this;
    }
    /**
     * Add item to ChangeDetail value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgChangeDetail $item
     * @return \dgsoft\ArrayType\DgArrayOfChangeDetail
     */
    public function addToChangeDetail(\dgsoft\StructType\DgChangeDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgChangeDetail) {
            throw new \InvalidArgumentException(sprintf('The ChangeDetail property can only contain items of \dgsoft\StructType\DgChangeDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ChangeDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgChangeDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgChangeDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgChangeDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgChangeDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgChangeDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ChangeDetail
     */
    public function getAttributeName()
    {
        return 'ChangeDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfChangeDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
