<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBookingRulesTypeBookingRuleAdditionalRule ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfBookingRulesTypeBookingRuleAdditionalRule extends AbstractStructArrayBase
{
    /**
     * The AdditionalRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AdditionalRule;
    /**
     * Constructor method for ArrayOfBookingRulesTypeBookingRuleAdditionalRule
     * @uses DgArrayOfBookingRulesTypeBookingRuleAdditionalRule::setAdditionalRule()
     * @param string[] $additionalRule
     */
    public function __construct(array $additionalRule = array())
    {
        $this
            ->setAdditionalRule($additionalRule);
    }
    /**
     * Get AdditionalRule value
     * @return string[]|null
     */
    public function getAdditionalRule()
    {
        return $this->AdditionalRule;
    }
    /**
     * Set AdditionalRule value
     * @uses \dgsoft\EnumType\DgAdditionalRule::valueIsValid()
     * @uses \dgsoft\EnumType\DgAdditionalRule::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $additionalRule
     * @return \dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAdditionalRule
     */
    public function setAdditionalRule(array $additionalRule = array())
    {
        $invalidValues = array();
        foreach ($additionalRule as $arrayOfBookingRulesTypeBookingRuleAdditionalRuleAdditionalRuleItem) {
            if (!\dgsoft\EnumType\DgAdditionalRule::valueIsValid($arrayOfBookingRulesTypeBookingRuleAdditionalRuleAdditionalRuleItem)) {
                $invalidValues[] = var_export($arrayOfBookingRulesTypeBookingRuleAdditionalRuleAdditionalRuleItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \dgsoft\EnumType\DgAdditionalRule::getValidValues())), __LINE__);
        }
        $this->AdditionalRule = $additionalRule;
        return $this;
    }
    /**
     * Add item to AdditionalRule value
     * @uses \dgsoft\EnumType\DgAdditionalRule::valueIsValid()
     * @uses \dgsoft\EnumType\DgAdditionalRule::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAdditionalRule
     */
    public function addToAdditionalRule($item)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgAdditionalRule::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \dgsoft\EnumType\DgAdditionalRule::getValidValues())), __LINE__);
        }
        $this->AdditionalRule[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \dgsoft\EnumType\DgAdditionalRule::valueIsValid()
     * @param string $item
     * @return \dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAdditionalRule
     */
    public function add($item)
    {
        if (!\dgsoft\EnumType\DgAdditionalRule::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \dgsoft\EnumType\DgAdditionalRule::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AdditionalRule
     */
    public function getAttributeName()
    {
        return 'AdditionalRule';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAdditionalRule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
