<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBasicPropertyInfoTypeContactNumber ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfBasicPropertyInfoTypeContactNumber extends AbstractStructArrayBase
{
    /**
     * The ContactNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgContactNumber[]
     */
    public $ContactNumber;
    /**
     * Constructor method for ArrayOfBasicPropertyInfoTypeContactNumber
     * @uses DgArrayOfBasicPropertyInfoTypeContactNumber::setContactNumber()
     * @param \dgsoft\StructType\DgContactNumber[] $contactNumber
     */
    public function __construct(array $contactNumber = array())
    {
        $this
            ->setContactNumber($contactNumber);
    }
    /**
     * Get ContactNumber value
     * @return \dgsoft\StructType\DgContactNumber[]|null
     */
    public function getContactNumber()
    {
        return $this->ContactNumber;
    }
    /**
     * Set ContactNumber value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgContactNumber[] $contactNumber
     * @return \dgsoft\ArrayType\DgArrayOfBasicPropertyInfoTypeContactNumber
     */
    public function setContactNumber(array $contactNumber = array())
    {
        foreach ($contactNumber as $arrayOfBasicPropertyInfoTypeContactNumberContactNumberItem) {
            // validation for constraint: itemType
            if (!$arrayOfBasicPropertyInfoTypeContactNumberContactNumberItem instanceof \dgsoft\StructType\DgContactNumber) {
                throw new \InvalidArgumentException(sprintf('The ContactNumber property can only contain items of \dgsoft\StructType\DgContactNumber, "%s" given', is_object($arrayOfBasicPropertyInfoTypeContactNumberContactNumberItem) ? get_class($arrayOfBasicPropertyInfoTypeContactNumberContactNumberItem) : gettype($arrayOfBasicPropertyInfoTypeContactNumberContactNumberItem)), __LINE__);
            }
        }
        $this->ContactNumber = $contactNumber;
        return $this;
    }
    /**
     * Add item to ContactNumber value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgContactNumber $item
     * @return \dgsoft\ArrayType\DgArrayOfBasicPropertyInfoTypeContactNumber
     */
    public function addToContactNumber(\dgsoft\StructType\DgContactNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgContactNumber) {
            throw new \InvalidArgumentException(sprintf('The ContactNumber property can only contain items of \dgsoft\StructType\DgContactNumber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactNumber[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgContactNumber|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgContactNumber|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgContactNumber|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgContactNumber|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgContactNumber|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContactNumber
     */
    public function getAttributeName()
    {
        return 'ContactNumber';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfBasicPropertyInfoTypeContactNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
