<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Voucher StructType
 * @package Dg
 * @subpackage Structs
 */
class DgVoucher extends AbstractStructBase
{
    /**
     * The SeriesCode
     * @var string
     */
    public $SeriesCode;
    /**
     * The BillingNumber
     * @var string
     */
    public $BillingNumber;
    /**
     * The SupplierIdentifier
     * @var string
     */
    public $SupplierIdentifier;
    /**
     * The Identifier
     * @var string
     */
    public $Identifier;
    /**
     * The ValueType
     * @var string
     */
    public $ValueType;
    /**
     * The ElectronicIndicator
     * @var bool
     */
    public $ElectronicIndicator;
    /**
     * Constructor method for Voucher
     * @uses DgVoucher::setSeriesCode()
     * @uses DgVoucher::setBillingNumber()
     * @uses DgVoucher::setSupplierIdentifier()
     * @uses DgVoucher::setIdentifier()
     * @uses DgVoucher::setValueType()
     * @uses DgVoucher::setElectronicIndicator()
     * @param string $seriesCode
     * @param string $billingNumber
     * @param string $supplierIdentifier
     * @param string $identifier
     * @param string $valueType
     * @param bool $electronicIndicator
     */
    public function __construct($seriesCode = null, $billingNumber = null, $supplierIdentifier = null, $identifier = null, $valueType = null, $electronicIndicator = null)
    {
        $this
            ->setSeriesCode($seriesCode)
            ->setBillingNumber($billingNumber)
            ->setSupplierIdentifier($supplierIdentifier)
            ->setIdentifier($identifier)
            ->setValueType($valueType)
            ->setElectronicIndicator($electronicIndicator);
    }
    /**
     * Get SeriesCode value
     * @return string|null
     */
    public function getSeriesCode()
    {
        return $this->SeriesCode;
    }
    /**
     * Set SeriesCode value
     * @param string $seriesCode
     * @return \dgsoft\StructType\DgVoucher
     */
    public function setSeriesCode($seriesCode = null)
    {
        // validation for constraint: string
        if (!is_null($seriesCode) && !is_string($seriesCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seriesCode)), __LINE__);
        }
        $this->SeriesCode = $seriesCode;
        return $this;
    }
    /**
     * Get BillingNumber value
     * @return string|null
     */
    public function getBillingNumber()
    {
        return $this->BillingNumber;
    }
    /**
     * Set BillingNumber value
     * @param string $billingNumber
     * @return \dgsoft\StructType\DgVoucher
     */
    public function setBillingNumber($billingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingNumber) && !is_string($billingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingNumber)), __LINE__);
        }
        $this->BillingNumber = $billingNumber;
        return $this;
    }
    /**
     * Get SupplierIdentifier value
     * @return string|null
     */
    public function getSupplierIdentifier()
    {
        return $this->SupplierIdentifier;
    }
    /**
     * Set SupplierIdentifier value
     * @param string $supplierIdentifier
     * @return \dgsoft\StructType\DgVoucher
     */
    public function setSupplierIdentifier($supplierIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($supplierIdentifier) && !is_string($supplierIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supplierIdentifier)), __LINE__);
        }
        $this->SupplierIdentifier = $supplierIdentifier;
        return $this;
    }
    /**
     * Get Identifier value
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->Identifier;
    }
    /**
     * Set Identifier value
     * @param string $identifier
     * @return \dgsoft\StructType\DgVoucher
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifier)), __LINE__);
        }
        $this->Identifier = $identifier;
        return $this;
    }
    /**
     * Get ValueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->ValueType;
    }
    /**
     * Set ValueType value
     * @param string $valueType
     * @return \dgsoft\StructType\DgVoucher
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: string
        if (!is_null($valueType) && !is_string($valueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($valueType)), __LINE__);
        }
        $this->ValueType = $valueType;
        return $this;
    }
    /**
     * Get ElectronicIndicator value
     * @return bool|null
     */
    public function getElectronicIndicator()
    {
        return $this->ElectronicIndicator;
    }
    /**
     * Set ElectronicIndicator value
     * @param bool $electronicIndicator
     * @return \dgsoft\StructType\DgVoucher
     */
    public function setElectronicIndicator($electronicIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($electronicIndicator) && !is_bool($electronicIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($electronicIndicator)), __LINE__);
        }
        $this->ElectronicIndicator = $electronicIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgVoucher
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
